package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.service.ScanCodeRecordReportService;
import com.biz.crm.admin.web.vo.BarCodeTraceReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码记录报表相关http
 * @author songjingen
 */
@Api(tags = "扫码记录报表（后台）")
@Slf4j
@RestController
@RequestMapping("/v1/web/scanCodeRecordReport")
public class ScanCodeRecordReportController {

  @Resource
  private ScanCodeRecordReportService scanCodeRecordReportService;

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码记录分页信息")
  @GetMapping(value = "/findByConditions")
  public Result<Page<ScanCodeRecordReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "dto", value = "扫码记录报表查询dto") ScanCodeRecordReportDto dto) {
    try {
      Page<ScanCodeRecordReportVo> page = scanCodeRecordReportService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分页查询包量任务管理扫码记录
   * @param quantifyTaskId 包量任务业务单号
   * @return 分页扫码记录
   */
  @ApiOperation(value = "分页查询包量任务管理扫码记录")
  @GetMapping(value = "/findByQuantifyTaskBusinessCode")
  public Result<Page<ScanCodeRecordReportVo>> findByQuantifyTaskBusinessCode(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "quantifyTaskId", value = "包量任务ID") @RequestParam("quantifyTaskId") String quantifyTaskId) {
    try {
      Page<ScanCodeRecordReportVo> page = scanCodeRecordReportService.findByQuantifyTaskBusinessCode(pageable, quantifyTaskId);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据扫码编码查询
   * @param recordCode
   * @return
   */
  @ApiOperation(value = "根据扫码编码查询")
  @GetMapping(value = "/findByRecordCodeAndParticipatorCode")
  public Result<ScanCodeRecordReportVo> findByRecordCodeAndParticipatorCode(@ApiParam(name = "recordCode", value = "扫码编码") @RequestParam("recordCode") String recordCode,
                                                         @ApiParam(name = "participatorCode", value = "参与者编码") @RequestParam("participatorCode") String participatorCode) {
    try {
      ScanCodeRecordReportVo vo = scanCodeRecordReportService.findByRecordCodeAndParticipatorCode(recordCode, participatorCode);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 码溯源查询
   * @param barCode 码编码
   * @return 码溯源VO
   */
  @ApiOperation(value = "根据扫码编码查询")
  @GetMapping(value = "/findBarCodeTraceByBarCode")
  public Result<BarCodeTraceReportVo> findBarCodeTraceByBarCode(@ApiParam(name = "barCode", value = "码编码") @RequestParam("barCode") String barCode) {
    try {
      BarCodeTraceReportVo vo = scanCodeRecordReportService.findBarCodeTraceByBarCode(barCode);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
