package com.biz.crm.admin.web.controller;

import com.biz.crm.admin.web.service.ScanCodeRecordWarningReportVoService;
import com.biz.crm.admin.web.vo.ScanCodeRecordWarningReportVo;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码记录预警信息报表控制器
 * @Author dy
 * @DATE 2022/4/12
 **/
@Api(tags = "扫码记录预警信息报表（后台）:ScanCodeRecordWarningReportVo:扫码记录预警信息报表（后台）")
@Slf4j
@RestController
@RequestMapping("/v1/web/scanCodeRecordWarningReport")
public class ScanCodeRecordWarningReportVoController {

  @Autowired
  private ScanCodeRecordWarningReportVoService scanCodeRecordWarningReportVoService;

  /**
   * 根据扫码记录编码获取预警详情
   *
   * @param recordCode
   * @return
   */
  @GetMapping("/findByRecordCode")
  @ApiOperation("根据扫码记录编码获取预警详情")
  public Result<ScanCodeRecordWarningReportVo> findByRecordCode(
      @RequestParam("recordCode") String recordCode) {
    try {
      ScanCodeRecordWarningReportVo scanCodeRecordWarningReportVo = this.scanCodeRecordWarningReportVoService.findByRecordCode(recordCode);
      return Result.ok(scanCodeRecordWarningReportVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
