package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.service.TerminalReportService;
import com.biz.crm.admin.web.vo.TerminalReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 分利终端报表controller
 * @author hefan
 */
@Api(tags = "分利终端报表controller")
@Slf4j
@RestController
@RequestMapping("/v1/web/terminalReport")
public class TerminalReportController {

  @Autowired
  private TerminalReportService terminalReportService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;" +
      "可传的参数：terminalCode：分利终端编码，terminalName：分利终端名称，organization: 所属组织, channel: 渠道")
  @GetMapping("findByConditions")
  public Result<Page<TerminalReportVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "terminalPaginationDto", value = "终端分页Dto") TerminalPaginationDto terminalPaginationDto) {
    try {
      Page<TerminalReportVo> result = this.terminalReportService.findByConditions(pageable, terminalPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
