package com.biz.crm.admin.web.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 协议明细报表查询条件dto
 * @Author: zengxingwang
 * @Date: 2021/9/23 15:07
 */
@Data
@ApiModel(value = "AgreementRewardDto", description = "协议明细报表查询条件dto")
public class AgreementRewardDto {

  /**
   * 政策名称
   */
  @ApiModelProperty("政策名称")
  private String policyName;

  /**
   * 奖励类型(1.红包2.积分3.费用)
   */
  @ApiModelProperty("奖励类型")
  private String rewardType;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型")
  private String type;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String code;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  private List<String> participatorCodes;
}
