package com.biz.crm.admin.web.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author hecheng
 * @description: 兑付流水Dto
 * @date 2021/8/31 下午4:41
 */
@Data
@ApiModel(value = "CashRecordReportDto", description = "兑付流水Dto")
public class CashRecordReportDto {

  /**
   * 兑付流水编码
   */
  @ApiModelProperty("兑付流水编码")
  private String cashCode;

  /**
   * 兑付类型标志
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型标志")
  private String cashMethodKey;

  /**
   * 兑付类型名称
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型名称")
  private String cashMethodName;

  /**
   * 所属奖励标志（费用，红包，等等）
   */
  @ApiModelProperty("奖励标志（费用，红包，等等）")
  private String rewardKey;

  /**
   * 所属奖励方式名称（费用，红包，等等）
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  private String rewardName;


  /**
   * 兑付状态
   */
  @ApiModelProperty("兑付状态")
  private String cashStatus;
  /**
   * 推送状态
   */
  @ApiModelProperty("推送状态")
  private String pushStatus;
  /**
   * 打款时间
   */
  @ApiModelProperty("打款时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date payDate;

  /**
   * 到账时间
   */
  @ApiModelProperty("到账时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date receiveDate;

  /**
   * 收款人编码 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("收款人编码")
  private String payeeCode;

  /**
   * 收款人姓名
   */
  @ApiModelProperty("收款人姓名")
  private String payeeName;
  /**
   * 收款人电话
   */
  @ApiModelProperty("收款人电话")
  private String payeePhone;
  /**
   * 收款人账户 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("收款人账户")
  private String payeeBank;
  /**
   * 参与者编码
   */
  @ApiModelProperty("客户编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("客户名称/终端名称/微信昵称")
  private String participatorName;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型")
  private String participatorType;
  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 标签
   */
  @ApiModelProperty("标签")
  private String tag;
  /**
   * 经销商/终端类型
   */
  @ApiModelProperty("经销商/终端类型")
  private String type;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String phone;
  /**
   * 打款开始时间
   */
  @ApiModelProperty("打款开始时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startPayDate;
  /**
   * 打款结束时间
   */
  @ApiModelProperty("打款结束时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endPayDate;

  /**
   * 到款开始时间
   */
  @ApiModelProperty("到款开始时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startReceiveDate;
  /**
   * 到款结束时间
   */
  @ApiModelProperty("到款结束时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endReceiveDate;
  /**
   * 推送开始时间
   */
  @ApiModelProperty("推送开始时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startPushDate;
  /**
   * 推送结束时间
   */
  @ApiModelProperty("推送结束时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endPushDate;
  /**
   * 身份证姓名
   *
   */
  @ApiModelProperty("身份证姓名")
  private String personName;

  /**
   * 身份证账号
   *
   */
  @ApiModelProperty("身份证账号")
  private String idCard ;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String mobile;

  /**
   * 银行账户
   */
  @ApiModelProperty("银行账户")
  private String bankCardNo;

  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 打款批次号
   */
  @ApiModelProperty("打款批次号")
  private String payBatchNo;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

}
