package com.biz.crm.admin.web.dto;

import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 消费者报表查询条件dto
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ConsumerReportDto", description = "消费者报表查询条件dto")
public class ConsumerReportDto extends ConsumerDto {

  /**
   * 累计分利金额 起始
   */
  @ApiModelProperty("累计分利金额起始")
  private BigDecimal cumulativeAmountStart;

  /**
   * 累计分利金额 结束
   */
  @ApiModelProperty("累计分利金额结束")
  private BigDecimal cumulativeAmountEnd;

  /**
   * 累计分利积分 起始
   */
  @ApiModelProperty("累计分利积分起始")
  private BigDecimal cumulativeIntegralStart;

  /**
   * 累计分利积分 结束
   */
  @ApiModelProperty("累计分利积分结束")
  private BigDecimal cumulativeIntegralEnd;
}
