package com.biz.crm.admin.web.dto;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 陈列政策分利任务报表DTO
 *
 * @author sunx
 * @date 2021/12/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayCalculateTaskReportDto", description = "陈列政策分利任务报表DTO")
public class DisplayCalculateTaskReportDto extends DisplayCalculateTask {

  /** 渠道 */
  @ApiModelProperty("渠道")
  private String channel;

  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /** 所属组织编码 */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /** 所属组织编码 */
  @ApiModelProperty("所属客户组织编码")
  private String customerOrgCode;

  /** 任务开始时间 */
  @ApiModelProperty("任务开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskStartTime;

  /** 任务结束时间 */
  @ApiModelProperty("任务结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskEndTime;

  /** 标签 */
  @ApiModelProperty("标签")
  private String tagDesc;

  /** 任务状态集合 */
  @ApiModelProperty("任务状态集合")
  private List<String> taskStatusList;

  /** 分离状态集合 */
  @ApiModelProperty("分离状态集合")
  private List<String> shareProfitStatusList;
}
