package com.biz.crm.admin.web.dto;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 陈列任务报表DTO
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "displayTaskReportDto", description = "陈列任务统计DTO")
public class DisplayTaskReportDto extends DisplayTask {

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属客户组织编码
   */
  @ApiModelProperty("所属客户组织编码")
  private String customerOrgCode;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织")
  private String orgName;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 所属模板名称
   */
  @ApiModelProperty("所属模板名称")
  private String templateName;

  /**
   * 任务状态(未开始，进行中，已分利)
   */
  @ApiModelProperty("任务状态(未开始，进行中，已分利)")
  private String taskStatus;

  /**
   * AI审核结果
   */
  @ApiModelProperty("AI审核结果")
  private String aiAuditResult;

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskStartTime;

  /**
   * 任务结束时间
   */
  @ApiModelProperty("任务结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskEndTime;

  /**
   * 终端标签
   */
  @ApiModelProperty("终端标签")
  private String terminalTag;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 审核状态
   */
  @ApiModelProperty("审核状态")
  private List<String> auditStatusList;

  /**
   * 状态
   */
  @ApiModelProperty("状态")
  private List<String> taskStatusList;
}
