package com.biz.crm.admin.web.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 积分明细流水分页查询dto
 *
 * @author sunx
 * @date 2022/3/24
 */
@Data
@ApiModel(value = "IntegralReportPaginationDto", description = "积分明细流水分页查询dto")
public class IntegralReportPaginationDto {

  /** 积分明细编码 */
  @ApiModelProperty("积分明细编码")
  private String code;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  private String orgName;

  /** 导购编码 */
  @ApiModelProperty("导购编码")
  private String participatorCode;

  /** 导购名称 */
  @ApiModelProperty("导购名称")
  private String participatorName;

  /** 客户类型 */
  @ApiModelProperty("客户类型")
  private String participatorType;

  /** 操作类型 */
  @ApiModelProperty("操作类型")
  private String rebateType;

  /** 关联业务类型 */
  @ApiModelProperty("关联业务类型")
  private String relateType;

  /** 关联扫码活动名称 */
  @ApiModelProperty("关联扫码活动名称")
  private String relateActName;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;
}
