package com.biz.crm.admin.web.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 包量任务报表DTO
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "quantifyTaskReportDto", description = "包量任务统计DTO")
public class QuantifyTaskReportDto {

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 终端标签
   */
  @ApiModelProperty("终端标签")
  private String terminalTag;

  /**
   * 所属模板名称
   */
  @ApiModelProperty("所属模板名称")
  private String templateName;

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskStartTime;

  /**
   * 任务结束时间
   */
  @ApiModelProperty("任务结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskEndTime;

  /**
   * 任务状态(未开始，进行中，已分利)
   */
  @ApiModelProperty("任务状态(未开始，进行中，已分利)")
  private String taskStatus;

  /**
   * 最小达成比例
   */
  @ApiModelProperty("最小达成比例")
  private BigDecimal reachRateMin;

  /**
   * 最大达成比例
   */
  @ApiModelProperty("最大达成比例")
  private BigDecimal reachRateMax;

  /**
   * 任务类型(年度，半年度，季度，月度)
   */
  @ApiModelProperty("任务类型(年度，半年度，季度，月度)")
  private String taskType;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgName;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 分利类型标记
   */
  @ApiModelProperty
  private String rewardTypeFlag;

  /**
   * 分利状态(未分利，已分利)
   */
  @ApiModelProperty("分利状态(未分利，已分利)")
  private String profitStatus;
}
