package com.biz.crm.admin.web.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 红包明细流水分页查询dto
 *
 * @author sunx
 * @date 2022/3/24
 */
@Data
@ApiModel(value = "RedPacketReportPaginationDto", description = "红包明细流水分页查询dto")
public class RedPacketReportPaginationDto {

  /** 积分明细编码 */
  @ApiModelProperty("积分明细编码")
  private String code;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  private String orgName;

  /** 导购编码 */
  @ApiModelProperty("导购编码")
  private String participatorCode;

  /** 导购名称 */
  @ApiModelProperty("导购名称")
  private String participatorName;

  /** 客户类型 */
  @ApiModelProperty(value = "客户类型",hidden = true)
  private String participatorType;

  /** 变更类型 */
  @ApiModelProperty("变更类型，1：增加 2：减少")
  private String type;

  /** 操作类型 */
  @ApiModelProperty("变更事件")
  private String rebateType;

  /** 关联业务类型 */
  @ApiModelProperty(value = "关联业务类型",hidden = true)
  private String relateType;

  /** 关联扫码活动名称 */
  @ApiModelProperty("关联扫码活动名称")
  private String relateActName;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;

  /** 渠道编码 */
  @ApiModelProperty("渠道编码")
  private String channel;

  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /** 经销商类型 */
  @ApiModelProperty("经销商类型")
  private String dealerType;
}
