package com.biz.crm.admin.web.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 奖励赠品流水明细表vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGiftDetailVo", description = "奖励赠品流水明细表vo")
public class RewardGiftDetailReportDto {

  private static final long serialVersionUID = -5387176716047899897L;

  /**
   * 赠品明细编码
   */
  @ApiModelProperty("赠品明细编码")
  private String code;

  /**
   * 赠品名称
   */
  @ApiModelProperty("赠品名称")
  private String materialName;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgCode;

  /**
   * 所属客户组织
   */
  @ApiModelProperty("所属客户组织")
  private String customerOrgCode;

  /**
   * 所属渠道
   */
  @ApiModelProperty("所属渠道")
  private String channelCode;

  /**
   * 参与者分利类型
   */
  @ApiModelProperty("参与者分利类型（经销商类型/终端类型）")
  private String type;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型（1-经销商，2-终端，3-消费者）")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码（经销商/终端/消费者）")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称（经销商/终端/消费者）")
  private String participatorName;

  /**
   * 所属协议模板编码
   */
  @ApiModelProperty("所属协议模板编码")
  private String templateCode;

  /**
   * 所属协议模板名称
   */
  @ApiModelProperty("所属协议模板名称")
  private String templateName;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("活动名称/政策名称")
  private String policyName;

  /**
   * 开始变更时间
   */
  @ApiModelProperty("开始变更时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startReleaseTime;

  /**
   * 结束变更时间
   */
  @ApiModelProperty("结束变更时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endReleaseTime;

}
