package com.biz.crm.admin.web.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 扫码协议报表dto
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeAgreementReportDto", description = "扫码协议报表dto")
public class ScanCodeAgreementReportDto {

  /**
   * 扫码编码
   */
  @ApiModelProperty("扫码编码")
  private String recordCode;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

}
