package com.biz.crm.admin.web.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 扫码记录报表
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRecordReportDto", description = "扫码记录报表dto")
public class ScanCodeRecordReportDto {

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 条码
   */
  @ApiModelProperty("条码")
  private String barCode;

  /**
   * 条码
   */
  @ApiModelProperty("条码")
  private List<String> barCodes;


  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channelName;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  private String channelCode;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 扫码开始时间
   */
  @ApiModelProperty("扫码开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date createTimeStart;

  /**
   * 扫码结束时间
   */
  @ApiModelProperty("扫码结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date createTimeEnd;

  /**
   * 扫码异常：0-无，1-重复扫码，2-已扫过箱码，对应的盒码作废！，3-已扫过盒码，对应的箱码作废！
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("扫码异常")
  private String scanCodeException;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private List<String> productCodes;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;
}
