package com.biz.crm.admin.web.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;

/**
 * 扫码记录报表分页查询dto
 *
 * @author sunx
 * @date 2022/3/24
 */
@Data
@ApiModel(value = "ScanCodeRecordReportPaginationDto", description = "扫码记录报表分页查询dto")
public class ScanCodeRecordReportPaginationDto {

  /** 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者) */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /** 码流转参与者编码 */
  @ApiModelProperty("码流转参与者编码")
  private String scanParticipatorCode;

  /** 码流转参与者编码集合查询 */
  @ApiModelProperty("码流转参与者编码集合查询")
  private Set<String> scanParticipatorCodeSet;

  /** 码流转参与者 */
  @ApiModelProperty("码流转参与者")
  private String scanParticipator;

  /** 电话 */
  @ApiModelProperty("电话")
  private String phone;

  /** 组织 */
  @ApiModelProperty("组织")
  private String orgName;

  /**
   * 客户组织
   */
  @ApiModelProperty("客户组织")
  private String customerOrgName;


  /** 扫码记录编码 */
  @ApiModelProperty(value = "扫码记录编码")
  private String recordCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;

  /**
   * 扫码异常：0-无，1-重复扫码，2-已扫过箱码，对应的盒码作废！，3-已扫过盒码，对应的箱码作废！
   */
  @ApiModelProperty("扫码异常")
  private String scanCodeException;

  /** 码 */
  @ApiModelProperty(value = "码")
  private String barCode;

  /** 物料编码 */
  @ApiModelProperty(value = "物料编码")
  private String productCode;

  /** 物料编码集合查询 */
  @ApiModelProperty(value = "物料编码集合查询")
  private Set<String> productCodeSet;

  /** 物料名称 */
  @ApiModelProperty("物料名称")
  private String productName;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 终端标签
   */
  @ApiModelProperty("终端标签")
  private String terminalTagDescription;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  private String channelCode;
}
