package com.biz.crm.admin.web.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerReportDto;
import com.biz.crm.admin.web.vo.ConsumerReportVo;
import org.apache.ibatis.annotations.Param;

/**
 * 消费者报表相关mybatis操作
 * @author songjingen
 */
public interface ConsumerReportMapper {
  /**
   * 消费者报表分页查询
   * @param page
   * @param dto
   * @return
   */
  Page<ConsumerReportVo> findByConditions(Page<ConsumerReportVo> page, @Param("dto") ConsumerReportDto dto);

  /**
   * 消费者分利信息
   * @param consumerCode 消费者编码
   * @return
   */
  ConsumerReportVo findDetailsByConsumerCode(@Param("consumerCode") String consumerCode);
}
