package com.biz.crm.admin.web.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.DisplayCalculateTaskReportDto;
import com.biz.crm.admin.web.dto.DisplayTaskReportDto;
import com.biz.crm.admin.web.vo.DisplayCalculateTaskReportVo;
import com.biz.crm.admin.web.vo.DisplayTaskReportVo;
import com.biz.crm.admin.web.vo.ShareProfitStatisticsVo;
import com.biz.crm.admin.web.vo.TaskScanCodeItemStatisticsVo;
import java.util.Date;
import org.apache.ibatis.annotations.Param;

/**
 * 陈列政策统计mapper
 *
 * @author HuaHongQiang
 */
public interface DisplayPolicyReportMapper {

  /**
   * 查询租户下的本月陈列统计信息
   *
   * @param tenantCode 租户code
   * @param monthStartTime 本月开始时间
   * @param monthEndTime 本月结束时间
   * @param taskStatus 任务状态
   * @return 陈列统计信息
   */
  Integer findDisplayStatisticsReportByTenant(
      @Param("tenantCode") String tenantCode,
      @Param("monthStartTime") Date monthStartTime,
      @Param("monthEndTime") Date monthEndTime,
      @Param("taskStatus") String taskStatus);

  /**
   * 分页条件查询陈列任务报表
   *
   * @param page 分页信息
   * @param dto 查询条件
   * @return 陈列任务报表
   */
  Page<DisplayTaskReportVo> findByConditions(
      @Param("page") Page<DisplayTaskReportVo> page, @Param("dto") DisplayTaskReportDto dto);

  /**
   * 陈列政策分利任务报表列表
   *
   * @param page
   * @param dto
   * @return
   */
  Page<DisplayCalculateTaskReportVo> findByDisplayCalculateTaskReportDto(
      @Param("page") Page<DisplayCalculateTaskReportVo> page,
      @Param("dto") DisplayCalculateTaskReportDto dto);

  /**
   * 陈列政策分利任务扫码情况
   *
   * @param page
   * @param businessCode
   * @return
   */
  Page<TaskScanCodeItemStatisticsVo> findTaskScanCodeItemStatisticsVo(
      @Param("page") Page<DisplayCalculateTaskReportVo> page,
      @Param("businessCode") String businessCode);

  /**
   * 陈列政策分利任务分利情况
   *
   * @param page
   * @param businessCode
   * @return
   */
  Page<ShareProfitStatisticsVo> findShareProfitStatisticsVo(
      @Param("page") Page<DisplayCalculateTaskReportVo> page,
      @Param("businessCode") String businessCode);
}
