package com.biz.crm.admin.web.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.QuantifyTaskReportDto;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.vo.QuantifyStatisticsReportVo;
import com.biz.crm.admin.web.vo.QuantifyTaskReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

/**
 * 包量政策统计mapper
 *
 * @author jerry7
 */
public interface QuantifyPolicyReportMapper {

  /**
   * 查询租户下的包量统计信息
   *
   * @param tenantCode 租户id
   * @param taskStatus 任务状态
   * @return 包量统计信息
   */
  Integer findQuantifyStatisticsReportByTenant(@Param("taskStatus") String taskStatus,@Param("tenantCode") String tenantCode);

  /**
   * 分页条件查询包量任务报表
   * @param page 分页信息
   * @param dto 查询条件
   * @return 包量任务报表
   */
  Page<QuantifyTaskReportVo> findByConditions(@Param("page") Page<QuantifyTaskReportVo> page, @Param("dto") QuantifyTaskReportDto dto);
}
