package com.biz.crm.admin.web.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.vo.QuantifyStatisticsVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/** @Author: zengxingwang @Date: 2021/11/24 15:51 */
public interface QuantifyStatisticsVoMapper {

  /**
   * 统计扫码
   *
   * @param dto
   * @return
   */
  List<QuantifyStatisticsVo> findByScanCodeRecordPageDto(@Param("dto") ScanCodeRecordPageDto dto);

  /**
   * 查询分利明细
   *
   * @param businessCode
   * @param page
   * @return
   */
  Page<QuantifyStatisticsVo> findByBusinessCodeAndTriggerAction(
      @Param("businessCode") String businessCode, Page<QuantifyStatisticsVo> page);

  /**
   * 单品包量扫码任务统计信息
   *
   * @param scanCodeRecordPageDto
   * @param page
   * @return
   */
  Page<QuantifyStatisticsVo> findByScanCodeRecordPageDtoForMaterial(
      @Param("dto") ScanCodeRecordPageDto scanCodeRecordPageDto, Page<QuantifyStatisticsVo> page);
}
