package com.biz.crm.admin.web.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.RedPacketReportPaginationDto;
import com.biz.crm.admin.web.vo.RedPacketReportVo;
import org.apache.ibatis.annotations.Param;

/**
 * 红包报表相关
 *
 * @author sunx
 * @date 2022/3/24
 */
public interface RedPacketReportMapper {

  /**
   * 明细分页
   *
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketReportVo> findByConditions(
      Page<RedPacketReportVo> page, @Param("dto") RedPacketReportPaginationDto dto);

  /**
   * 终端红包明细分页
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketReportVo> findTerminalByConditions(
      Page<RedPacketReportVo> page, @Param("dto") RedPacketReportPaginationDto dto);

  /**
   * 经销商红包明细分页
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketReportVo> findDealerByConditions(
      Page<RedPacketReportVo> page, @Param("dto") RedPacketReportPaginationDto dto);
}
