package com.biz.crm.admin.web.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 扫码记录报表相关mybatis
 * @author songjingen
 */
public interface ScanCodeRecordReportMapper {
  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   * @param page
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportVo> findByConditions(@Param("page") Page<?> page, @Param("dto") ScanCodeRecordReportDto dto);

  /**
   * 条件查询扫码信息
   * @param dto 查询条件
   * @return 扫码记录
   */
  List<ScanCodeRecordReportVo> findByConditions(@Param("dto") ScanCodeRecordReportDto dto);

  /**
   * 根据扫码编码查询
   * @param recordCode
   * @return
   */
  ScanCodeRecordReportVo findByRecordCodeAndParticipatorCode(@Param("recordCode") String recordCode, @Param("participatorCode") String participatorCode);

  /**
   *
   * 查询可用扫码明细（红包）
   * @param recordCodes
   * @author rentao
   * @date
   */
  List<ScanCodeRecordReportVo> findRedPacketByRecordCodes(@Param("recordCodes") List<String> recordCodes);

  /**
   *
   * 查询可用扫码明细（客户）
   * @param recordCodes
   * @author rentao
   * @date
   */
  List<ScanCodeRecordReportVo> findCostDealerByRecordCodes(@Param("recordCodes") List<String> recordCodes);

  /**
   *
   * 查询可用扫码明细（终端）
   * @param recordCodes
   * @author rentao
   * @date
   */
  List<ScanCodeRecordReportVo> findCostTerminalByRecordCodes(@Param("recordCodes") List<String> recordCodes);

  /**
   *
   * 查询可用扫码明细（积分）
   * @param recordCodes
   * @author rentao
   * @date
   */
  List<ScanCodeRecordReportVo> findRewardIntegralByRecordCodes(@Param("recordCodes") List<String> recordCodes);
}
