package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.AgreementRewardDto;
import com.biz.crm.admin.web.mapper.AgreementRewardVoMapper;
import com.biz.crm.admin.web.vo.AgreementRewardVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 协议分利明细报表相关sql
 * @Author: zengxingwang
 * @Date: 2021/9/23 15:03
 */
@Component
public class AgreementRewardVoRepository {

  @Autowired
  private AgreementRewardVoMapper agreementRewardVoMapper;

  /**
   * 协议分利明细报表多条件查询
   * @param pageable
   * @param agreementRewardDto
   * @return
   */
  public Page<AgreementRewardVo> findByConditions(Pageable pageable, AgreementRewardDto agreementRewardDto) {
    Page<AgreementRewardVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AgreementRewardVo> selectPage = agreementRewardVoMapper.findByConditions(page, agreementRewardDto);
    return selectPage;
  }
}
