package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.CashRecordReportDto;
import com.biz.crm.admin.web.mapper.CashRecordReportVoMapper;
import com.biz.crm.admin.web.vo.CashRecordReportVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @author hecheng
 * @description: 提现记录流水报表相关数据库操作
 * @date 2021/10/11 下午4:59
 */
@Component
public class CashRecordReportVoRepository {

  @Autowired
  private CashRecordReportVoMapper cashRecordReportVoMapper;

  /**
   * 通过查询条件查询终端的扫码记录分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<CashRecordReportVo> findTerminalByConditions(Pageable pageable, CashRecordReportDto dto) {
    Page<CashRecordReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setParticipatorType(ParticipatorTypeEnum.TERMINAL.getDictCode());
    return cashRecordReportVoMapper.findTerminalByConditions(page, dto);
  }

  /**
   * 通过查询条件查询经销商的扫码记录分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<CashRecordReportVo> findDealerByConditions(Pageable pageable, CashRecordReportDto dto) {
    Page<CashRecordReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setParticipatorType(ParticipatorTypeEnum.DEALER.getDictCode());
    return cashRecordReportVoMapper.findDealerByConditions(page, dto);
  }

  /**
   * 通过查询条件查询消费者的扫码记录分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<CashRecordReportVo> findConsumerByConditions(Pageable pageable, CashRecordReportDto dto) {
    Page<CashRecordReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setParticipatorType(ParticipatorTypeEnum.CONSUMER.getDictCode());
    return cashRecordReportVoMapper.findConsumerByConditions(page, dto);
  }

  /**
   * 通过查询条件查询导购的扫码记录分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<CashRecordReportVo> findUserGuideByConditions(Pageable pageable, CashRecordReportDto dto) {
    Page<CashRecordReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setParticipatorType(ParticipatorTypeEnum.USER_GUIDE.getDictCode());
    return cashRecordReportVoMapper.findUserGuideByConditions(page, dto);
  }
}
