package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerReportDto;
import com.biz.crm.admin.web.mapper.ConsumerReportMapper;
import com.biz.crm.admin.web.vo.ConsumerReportVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 消费者报表相关sql
 * @author songjingen
 */
@Component
public class ConsumerReportRepository {

  @Resource
  private ConsumerReportMapper consumerReportMapper;

  /**
   * 消费者报表分页查询
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ConsumerReportVo> findByConditions(Pageable pageable, ConsumerReportDto dto) {
    Page<ConsumerReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ConsumerReportVo> selectPage = consumerReportMapper.findByConditions(page, dto);
    return selectPage;
  }

  /**
   * 消费者分利信息
   * @param consumerCode 消费者编码
   * @return
   */
  public ConsumerReportVo findDetailsByConsumerCode(String consumerCode) {
    return this.consumerReportMapper.findDetailsByConsumerCode(consumerCode);
  }
}
