package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerTerminalMappingDto;
import com.biz.crm.admin.web.mapper.ConsumerTerminalMappingReportMapper;
import com.biz.crm.admin.web.vo.ConsumerTerminalMappingReportVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 消费者关联终端报表相关sql
 * @author songjingen
 */
@Component
public class ConsumerTerminalMappingReportRepository {

  @Resource
  private ConsumerTerminalMappingReportMapper consumerTerminalMappingReportMapper;

  /**
   * 消费者关联终端报表分页查询
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ConsumerTerminalMappingReportVo> findByConditions(Pageable pageable, ConsumerTerminalMappingDto dto) {
    Page<ConsumerTerminalMappingReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ConsumerTerminalMappingReportVo> selectPage = consumerTerminalMappingReportMapper.findByConditions(page, dto);
    return selectPage;
  }

  /**
   * 消费者关联终端
   * @param dto
   * @return
   */
  public List<ConsumerTerminalMappingReportVo> findByConditions(ConsumerTerminalMappingDto dto) {
    return consumerTerminalMappingReportMapper.findByConditions(dto);
  }
}
