package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.admin.web.dto.ContractSignReportDto;
import com.biz.crm.admin.web.mapper.ContractSignReportVoMapper;
import com.biz.crm.admin.web.vo.ContractSignReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 合同签署报表相关数据库操作
 * @author songjingen
 */
@Component
public class ContractSignReportVoRepository extends ServiceImpl<ContractSignReportVoMapper, ContractSignReportVo> {

  @Autowired
  private ContractSignReportVoMapper contractSignReportVoMapper;

  /**
   * 根据条件分页查询列表
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ContractSignReportVo> findByConditions(Pageable pageable, ContractSignReportDto dto) {
    Page<ContractSignReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.contractSignReportVoMapper.findByConditions(page, dto);
  }
}
