package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.CostDetailReportPaginationDto;
import com.biz.crm.admin.web.mapper.CostDetailReportVoMapper;
import com.biz.crm.admin.web.vo.CostDetailReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @Author dy
 * @DATE 2022/4/22
 **/
@Component
public class CostDetailReportVoRepository {

  @Autowired
  private CostDetailReportVoMapper costDetailReportVoMapper;

  /**
   * 分页查询经销商费用明细
   * @param pageable
   * @param dto
   * @return
   */
  public Page<CostDetailReportVo> findDealerByConditions(Pageable pageable, CostDetailReportPaginationDto dto){
    Page<CostDetailReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costDetailReportVoMapper.findDealerByConditions(page,dto);
  }
}
