package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.DisplayCalculateTaskReportDto;
import com.biz.crm.admin.web.dto.DisplayTaskReportDto;
import com.biz.crm.admin.web.mapper.DisplayPolicyReportMapper;
import com.biz.crm.admin.web.vo.DisplayCalculateTaskReportVo;
import com.biz.crm.admin.web.vo.DisplayTaskReportVo;
import com.biz.crm.admin.web.vo.ShareProfitStatisticsVo;
import com.biz.crm.admin.web.vo.TaskScanCodeItemStatisticsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 陈列报表相关数据库操作
 *
 * @author HuaHongQiang
 */
@Component
public class DisplayPolicyReportRepository {

  @Resource private DisplayPolicyReportMapper displayPolicyReportMapper;

  /**
   * 查询租户下的本月陈列统计信息
   *
   * @param tenantCode 租户code
   * @param monthStartTime 本月开始时间
   * @param monthEndTime 本月结束时间
   * @param taskStatus 任务状态
   * @return 陈列统计信息
   */
  public Integer findDisplayStatisticsReportByTenant(
      String tenantCode, Date monthStartTime, Date monthEndTime, String taskStatus) {
    return this.displayPolicyReportMapper.findDisplayStatisticsReportByTenant(
        tenantCode, monthStartTime, monthEndTime, taskStatus);
  }

  /**
   * 分页条件查询陈列任务报表
   *
   * @param pageable 分页信息
   * @param dto 查询条件
   * @return 陈列任务报表
   */
  public Page<DisplayTaskReportVo> findByConditions(Pageable pageable, DisplayTaskReportDto dto) {
    Page<DisplayTaskReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.displayPolicyReportMapper.findByConditions(page, dto);
  }

  /**
   * 陈列政策分利任务报表列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<DisplayCalculateTaskReportVo> findByDisplayCalculateTaskReportDto(
      Pageable pageable, DisplayCalculateTaskReportDto dto) {
    Page<DisplayCalculateTaskReportVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.displayPolicyReportMapper.findByDisplayCalculateTaskReportDto(page, dto);
  }

  /**
   * 陈列政策分利任务扫码情况
   *
   * @param pageable
   * @param businessCode
   * @return
   */
  public Page<TaskScanCodeItemStatisticsVo> findTaskScanCodeItemStatisticsVo(
      Pageable pageable, String businessCode) {
    Page<DisplayCalculateTaskReportVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());

    return this.displayPolicyReportMapper.findTaskScanCodeItemStatisticsVo(page, businessCode);
  }

  /**
   * 陈列政策分利任务分利情况
   *
   * @param pageable
   * @param businessCode
   * @return
   */
  public Page<ShareProfitStatisticsVo> findShareProfitStatisticsVo(
      Pageable pageable, String businessCode) {
    Page<DisplayCalculateTaskReportVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());

    return this.displayPolicyReportMapper.findShareProfitStatisticsVo(page, businessCode);
  }
}
