package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.IntegralReportPaginationDto;
import com.biz.crm.admin.web.mapper.IntegralReportMapper;
import com.biz.crm.admin.web.vo.IntegralReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 积分报表相关
 *
 * @author sunx
 * @date 2022/3/24
 */
@Component
public class IntegralReportRepository {

  @Autowired private IntegralReportMapper integralReportMapper;

  /**
   * 积分明细分页
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<IntegralReportVo> findByConditions(
      Pageable pageable, IntegralReportPaginationDto dto) {
    Page<IntegralReportVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.integralReportMapper.findByConditions(page, dto);
  }
}
