package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ParticipatorRewardDto;
import com.biz.crm.admin.web.mapper.ParticipatorRewardVoMapper;
import com.biz.crm.admin.web.vo.ParticipatorRewardVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 参与者分利明细报表相关sql
 * @Author: zengxingwang
 * @Date: 2021/9/24 14:37
 */
@Component
public class ParticipatorRewardVoRepository {

  @Autowired
  private ParticipatorRewardVoMapper participatorRewardVoMapper;

  /**
   * 多条件分页查询
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ParticipatorRewardVo> findByConditions(Pageable pageable, ParticipatorRewardDto dto) {
    Page<ParticipatorRewardVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ParticipatorRewardVo> selectPage = participatorRewardVoMapper.findByConditions(page, dto);
    return selectPage;
  }
}
