package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.QuantifyTaskReportDto;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.mapper.QuantifyPolicyReportMapper;
import com.biz.crm.admin.web.mapper.ScanCodeRecordReportMapper;
import com.biz.crm.admin.web.vo.QuantifyStatisticsReportVo;
import com.biz.crm.admin.web.vo.QuantifyTaskReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 扫码记录报表相关数据库操作
 *
 * @author songjingen
 */
@Component
public class QuantifyPolicyReportRepository {

  @Autowired
  private QuantifyPolicyReportMapper quantifyPolicyReportMapper;


  public Integer findQuantifyStatisticsReportByTenant(String taskStatus,String tenantCode) {
    return quantifyPolicyReportMapper.findQuantifyStatisticsReportByTenant(taskStatus,tenantCode);
  }

  /**
   * 分页条件查询包量任务报表
   * @param pageable 分页信息
   * @param dto 查询条件
   * @return 包量任务报表
   */
  public Page<QuantifyTaskReportVo> findByConditions(Pageable pageable, QuantifyTaskReportDto dto) {
    Page<QuantifyTaskReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.quantifyPolicyReportMapper.findByConditions(page, dto);
  }
}
