package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.mapper.QuantifyStatisticsVoMapper;
import com.biz.crm.admin.web.vo.QuantifyStatisticsVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/** @Author: zengxingwang @Date: 2021/11/24 15:43 */
@Component
public class QuantifyStatisticsVoRepository {

  @Autowired private QuantifyStatisticsVoMapper quantifyStatisticsVoMapper;

  /**
   * 统计扫码
   *
   * @param dto
   * @return
   */
  public List<QuantifyStatisticsVo> findByScanCodeRecordPageDto(ScanCodeRecordPageDto dto) {
    return quantifyStatisticsVoMapper.findByScanCodeRecordPageDto(dto);
  }

  /**
   * 查询分利明细
   *
   * @param businessCode
   * @param pageable
   * @return
   */
  public Page<QuantifyStatisticsVo> findByBusinessCodeAndTriggerAction(
      String businessCode, Pageable pageable) {
    Page<QuantifyStatisticsVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return quantifyStatisticsVoMapper.findByBusinessCodeAndTriggerAction(businessCode, page);
  }

  /**
   * 单品包量任务扫码明细统计信息
   *
   * @param scanCodeRecordPageDto
   * @param pageable
   * @return
   */
  public Page<QuantifyStatisticsVo> findByScanCodeRecordPageDtoForMaterial(
      ScanCodeRecordPageDto scanCodeRecordPageDto, Pageable pageable) {
    Page<QuantifyStatisticsVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.quantifyStatisticsVoMapper.findByScanCodeRecordPageDtoForMaterial(
        scanCodeRecordPageDto, page);
  }
}
