package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.RedPacketReportPaginationDto;
import com.biz.crm.admin.web.mapper.RedPacketReportMapper;
import com.biz.crm.admin.web.vo.RedPacketReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 红包报表
 *
 * @author sunx
 * @date 2022/3/24
 */
@Component
public class RedPacketReportRepository {

  @Autowired private RedPacketReportMapper redPacketReportMapper;

  /**
   * 明细分页
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketReportVo> findByConditions(
      Pageable pageable, RedPacketReportPaginationDto dto) {
    Page<RedPacketReportVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketReportMapper.findByConditions(page, dto);
  }

  /**
   * 明细分页 --终端
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketReportVo> findTerminalByConditions(
      Pageable pageable, RedPacketReportPaginationDto dto) {
    Page<RedPacketReportVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketReportMapper.findTerminalByConditions(page, dto);
  }

  /**
   * 明细分页 --经销商
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketReportVo> findDealerByConditions(
      Pageable pageable, RedPacketReportPaginationDto dto) {
    Page<RedPacketReportVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketReportMapper.findDealerByConditions(page, dto);
  }
}
