package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.mapper.RewardActivityReceiveVoMapper;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityReceiveDto;
import com.biz.crm.cps.business.activity.actual.sdk.vo.RewardActivityReceiveVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @Author: zengxingwang
 * @Date: 2021/10/20 15:05
 */
@Component
public class RewardActivityReceiveVoRepository {

  @Autowired
  private RewardActivityReceiveVoMapper rewardActivityReceiveVoMapper;

  /**
   * 条件查询中奖列表
   * @param dto
   * @param pageable
   * @return
   */
  public Page<RewardActivityReceiveVo> findByConditions(RewardActivityReceiveDto dto, Pageable pageable) {
    Page<RewardActivityReceiveVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return rewardActivityReceiveVoMapper.findByConditions(dto, page);
  }
}
