package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.admin.web.dto.RewardGiftDetailReportDto;
import com.biz.crm.admin.web.mapper.RewardGiftDetailReportMapper;
import com.biz.crm.admin.web.vo.RewardGiftDetailReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 奖励赠品流水明细报表相关数据库操作
 * @author songjingen
 */
@Component
public class RewardGiftDetailReportRepository extends ServiceImpl<RewardGiftDetailReportMapper, RewardGiftDetailReportVo> {

  @Autowired
  private RewardGiftDetailReportMapper rewardGiftDetailReportMapper;

  /**
   * 奖励赠品流水明细报表分页查询
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RewardGiftDetailReportVo> findByConditions(Pageable pageable, RewardGiftDetailReportDto dto) {
    Page<RewardGiftDetailReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.rewardGiftDetailReportMapper.findByConditions(page, dto);
  }

}
