package com.biz.crm.admin.web.repository;

import com.biz.crm.admin.web.mapper.RewardReportVoMapper;
import com.biz.crm.admin.web.vo.RewardReportVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 奖励报表相关
 * @author sunx
 * @date 2022/3/28
 */
@Component
public class RewardReportVoRepository {

  @Autowired private RewardReportVoMapper rewardReportVoMapper;

  /**
   * 根据扫码记录编码获取分利返利明细
   *
   * @param recordCode
   * @return
   */
    public List<RewardReportVo> findByRecordCode(String recordCode) {
      return this.rewardReportVoMapper.findByRecordCode(recordCode);
    }
}
