package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportPaginationDto;
import com.biz.crm.admin.web.mapper.ScanCodeRecordReportAllVoMapper;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 扫码记录报表 - all
 *
 * @author sunx
 * @date 2022/3/29
 */
@Component
public class ScanCodeRecordReportAllVoRepository {

  @Autowired private ScanCodeRecordReportAllVoMapper scanCodeRecordReportAllVoMapper;

  /**
   * 扫码记录报表-all
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ScanCodeRecordReportAllVo> findAllByConditions(
      Pageable pageable, ScanCodeRecordReportPaginationDto dto) {
    Page<ScanCodeRecordReportAllVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.scanCodeRecordReportAllVoMapper.findAllByConditions(
        page, dto, ScanCodeExceptionEnum.NO_ACTIVITY.getCode());
  }
}
