package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.mapper.ScanCodeRecordReportMapper;
import com.biz.crm.admin.web.vo.ScanCodeRecordRelateActivityVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.business.reward.sdk.common.enums.RewardRelateTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 扫码记录报表相关数据库操作
 * @author songjingen
 */
@Component
public class ScanCodeRecordReportRepository {

  @Resource
  private ScanCodeRecordReportMapper scanCodeRecordReportMapper;


  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ScanCodeRecordReportVo> findByConditions(Pageable pageable, ScanCodeRecordReportDto dto) {
    Page<ScanCodeRecordReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ScanCodeRecordReportVo> voPage = scanCodeRecordReportMapper.findByConditions(page, dto);
    return voPage;
  }

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   * @param dto 查询条件
   * @return 扫码记录列表
   */
  public List<ScanCodeRecordReportVo> findByConditions(ScanCodeRecordReportDto dto) {
    List<ScanCodeRecordReportVo> recordReportVos = scanCodeRecordReportMapper.findByConditions(dto);
    return recordReportVos;
  }

  /**
   * 根据扫码编码查询
   * @param recordCode
   * @return
   */
  public ScanCodeRecordReportVo findByRecordCodeAndParticipatorCode(String recordCode, String participatorCode) {
    return scanCodeRecordReportMapper.findByRecordCodeAndParticipatorCode(recordCode, participatorCode);
  }

  /**
   *
   * 扫码记录编码 集合查询可用扫码记录（红包 积分 客户 终端）
   * @param recordCodes
   * @author rentao
   * @date
   */
  public List<ScanCodeRecordReportVo> findTemplateCodeByRecordCodes(List<String> recordCodes){
    List<ScanCodeRecordReportVo> list = new ArrayList<>();
    List<ScanCodeRecordReportVo> redPacketByRecordCodes = scanCodeRecordReportMapper.findRedPacketByRecordCodes(recordCodes);
    List<ScanCodeRecordReportVo> costDealerByRecordCodes = scanCodeRecordReportMapper.findCostDealerByRecordCodes(recordCodes);
    List<ScanCodeRecordReportVo> costTerminalByRecordCodes = scanCodeRecordReportMapper.findCostTerminalByRecordCodes(recordCodes);
    List<ScanCodeRecordReportVo> rewardIntegralByRecordCodes = scanCodeRecordReportMapper.findRewardIntegralByRecordCodes(recordCodes);
    if(CollectionUtils.isNotEmpty(redPacketByRecordCodes)){
      list.addAll(redPacketByRecordCodes);
    }
    if(CollectionUtils.isNotEmpty(costDealerByRecordCodes)){
      list.addAll(costDealerByRecordCodes);
    }
    if(CollectionUtils.isNotEmpty(costTerminalByRecordCodes)){
      list.addAll(costTerminalByRecordCodes);
    }
    if(CollectionUtils.isNotEmpty(rewardIntegralByRecordCodes)){
      list.addAll(rewardIntegralByRecordCodes);
    }
    return list;
  }
}
