package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.biz.crm.admin.web.dto.CashRecordReportDto;
import com.biz.crm.admin.web.vo.CashRecordReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 提现流水报表
 *
 * @author hecheng
 */
public interface CashRecordReportVoService {

  /**
   * 分页查询终端兑现流水
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findTerminalByConditions(Pageable pageable, CashRecordReportDto dto);

  /**
   * 分页查询经销商兑现流水
   * @param pageable
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findDealerByConditions(Pageable pageable, CashRecordReportDto dto);

  /**
   * 分页查询消费者兑现流水
   * @param pageable
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findConsumerByConditions(Pageable pageable, CashRecordReportDto dto);

  /**
   * 分页查询导购兑现流水
   * @param pageable
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findUserGuideByConditions(Pageable pageable, CashRecordReportDto dto);
}
