package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerReportDto;
import com.biz.crm.admin.web.vo.ConsumerReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 消费者报表service
 * @author songjingen
 */
public interface ConsumerReportService {

  /**
   * 消费者报表分页查询
   * @param pageable
   * @param dto
   * @return
   */
  Page<ConsumerReportVo> findByConditions(Pageable pageable, ConsumerReportDto dto);

  /**
   * 消费者分利信息
   * @param consumerCode 消费者编码
   * @return
   */
  ConsumerReportVo findDetailsByConsumerCode(String consumerCode);
}
