package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.DisplayCalculateTaskReportDto;
import com.biz.crm.admin.web.dto.DisplayTaskReportDto;
import com.biz.crm.admin.web.dto.TaskScanCodeItemStatisticsDto;
import com.biz.crm.admin.web.vo.DisplayCalculateTaskReportVo;
import com.biz.crm.admin.web.vo.DisplayStatisticsReportVo;
import com.biz.crm.admin.web.vo.DisplayTaskReportVo;
import com.biz.crm.admin.web.vo.ShareProfitStatisticsVo;
import com.biz.crm.admin.web.vo.TaskScanCodeItemStatisticsVo;
import com.biz.crm.admin.web.vo.TaskScanCodeStatisticsVo;
import org.springframework.data.domain.Pageable;

/**
 * 陈列统计service
 * @author HuaHongQiang
 */
public interface DisplayPolicyReportService {

  /**
   * 获取当前tenant下的陈列统计信息
   * @return 陈列统计信息
   */
  DisplayStatisticsReportVo findDisplayStatisticsReportByTenant();

  /**
   * 分页条件查询陈列任务报表
   * @param pageable 分页信息
   * @param dto 查询条件
   * @return 陈列任务报表
   */
  Page<DisplayTaskReportVo> findByConditions(Pageable pageable, DisplayTaskReportDto dto);

  /**
   * 陈列政策分利任务报表列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<DisplayCalculateTaskReportVo> findByDisplayCalculateTaskReportDto(Pageable pageable,
      DisplayCalculateTaskReportDto dto);

  /**
   * 陈列政策分利任务扫码情况
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<TaskScanCodeItemStatisticsVo> findTaskScanCodeItemStatisticsVo(Pageable pageable, TaskScanCodeItemStatisticsDto dto);

  /**
   * 陈列政策分利任务分利情况
   *
   * @param pageable
   * @param businessCode
   * @return
   */
  Page<ShareProfitStatisticsVo> findShareProfitStatisticsVo(Pageable pageable, String businessCode);

  /**
   * 任务扫码数据统计信息
   *
   * @param businessCode
   * @return
   */
  TaskScanCodeStatisticsVo findTaskScanCodeStatisticsVo(String businessCode);
}
