package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.QuantifyTaskReportDto;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.vo.QuantifyStatisticsReportVo;
import com.biz.crm.admin.web.vo.QuantifyTaskReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 包量统计service
 * @author jerry7
 */
public interface QuantifyPolicyReportService {

  /**
   * 获取当前tenant下的包量统计信息
   * @return 包量统计信息
   */
  QuantifyStatisticsReportVo findQuantifyStatisticsReportByTenant();

  /**
   * 分页条件查询包量任务报表
   * @param pageable 分页信息
   * @param dto 查询条件
   * @return 包量任务报表
   */
  Page<QuantifyTaskReportVo> findByConditions(Pageable pageable, QuantifyTaskReportDto dto);
}
