package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.vo.QuantifyStatisticsVo;
import org.springframework.data.domain.Pageable;

/**
 * 包量任务统计接口定义
 * @Author: zengxingwang
 * @Date: 2021/11/23 16:42
 */
public interface QuantifyStatisticsVoTaskService {

  /**
   * 查询销量明细
   * @param businessCode
   * @return
   */
  Page<QuantifyStatisticsVo> findByBusinessCode(String businessCode, Pageable pageable);

  /**
   * 查询销量明细-单品纬度
   * @param businessCode
   * @return
   */
  Page<QuantifyStatisticsVo> findByBusinessCodeForForMaterial(String businessCode, Pageable pageable);

  /**
   * 查询返利明细
   * @param businessCode
   * @param pageable
   * @return
   */
  Page<QuantifyStatisticsVo> findByBusinessCodeAndTriggerAction(String businessCode, Pageable pageable);
}
