package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.RedPacketReportPaginationDto;
import com.biz.crm.admin.web.vo.RedPacketReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 红包报表 接口
 *
 * @author sunx
 * @date 2022/3/24
 */
public interface RedPacketReportService {

  /**
   * 红包明细分页查询 --导购
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<RedPacketReportVo> findByConditions(
      Pageable pageable, RedPacketReportPaginationDto dto);

  /**
   * 红包明细分页查询 --终端
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<RedPacketReportVo> findTerminalByConditions(
      Pageable pageable, RedPacketReportPaginationDto dto);

  /**
   * 红包明细分页查询 --经销商
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<RedPacketReportVo> findDealerByConditions(
      Pageable pageable, RedPacketReportPaginationDto dto);
}
