package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportPaginationDto;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportAllVo;
import org.springframework.data.domain.Pageable;

/**
 * 扫码记录all 接口
 *
 * @author sunx
 * @date 2022/3/29
 */
public interface ScanCodeRecordReportAllVoService {

  /**
   * 导购扫码记录新报表
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportAllVo> findUserGuideByConditions(Pageable pageable, ScanCodeRecordReportPaginationDto dto);


  /**
   * 终端用户扫码记录报表
   * @param pageable
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportAllVo> findTerminalByConditions(Pageable pageable,ScanCodeRecordReportPaginationDto dto);


  /**
   * 经销商扫码记录报表
   * @param pageable
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportAllVo> findDealerByConditions(Pageable pageable,ScanCodeRecordReportPaginationDto dto);
}
