package com.biz.crm.admin.web.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.vo.BarCodeTraceReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 扫码记录报表service
 * @author songjingen
 */
public interface ScanCodeRecordReportService {

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   * @param pageable
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportVo> findByConditions(Pageable pageable, ScanCodeRecordReportDto dto);

  /**
   * 根据包量任务业务单号查询扫码记录
   * @param pageable 分页信息
   * @param businessCode 包量任务业务单号
   * @return 扫码记录
   */
  Page<ScanCodeRecordReportVo> findByQuantifyTaskBusinessCode(Pageable pageable, String businessCode);

  /**
   * 根据扫码编码查询
   * @param recordCode
   * @return
   */
  ScanCodeRecordReportVo findByRecordCodeAndParticipatorCode(String recordCode, String participatorCode);

  /**
   * 查找码回溯vo
   * @param barCode 码编码
   * @return 码回溯VO
   */
  BarCodeTraceReportVo findBarCodeTraceByBarCode(String barCode);
}
