package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.AgreementRewardDto;
import com.biz.crm.admin.web.service.AgreementReportVoService;
import com.biz.crm.admin.web.service.AgreementRewardVoService;
import com.biz.crm.admin.web.service.RewardRelAgreementVoService;
import com.biz.crm.admin.web.vo.AgreementReportVo;
import com.biz.crm.admin.web.vo.AgreementRewardVo;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeRange;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeConfigurationService;
import com.biz.crm.cps.business.product.sdk.common.constant.MaterialDimensionConstant;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.cost.sdk.common.CostConstant;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralEntity;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralService;
import com.biz.crm.cps.business.reward.integral.sdk.common.constant.IntegralConstant;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.common.constant.RedPacketConstant;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 协议分利报表service实现
 * @Author: zengxingwang
 * @Date: 2021/9/18 14:03
 */
@Service
public class AgreementReportVoServiceImpl implements AgreementReportVoService {

  @Autowired
  private AgreementVoService agreementVoService;
  @Autowired
  private RedPacketService redPacketService;
  @Autowired
  private ConsumerVoService consumerVoService;
  @Autowired
  private CostDealerService costDealerService;
  @Autowired
  private CostTerminalService costTerminalService;
  @Autowired
  private IntegralService integralService;
  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;
  @Autowired
  private AgreementRewardVoService agreementRewardVoService;
  @Autowired
  private RewardRelAgreementVoService rewardRelAgreementVoService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private ScanCodeConfigurationService scanCodeConfigurationService;
  @Autowired
  private MaterialVoService materialVoService;

  /**
   * 根据编码和类型查询
   * @param code
   * @param type
   * @return
   */
  @Override
  public AgreementReportVo findAgreementAndType(String code, String type) {
    if (StringUtils.isBlank(code) || StringUtils.isBlank(type)) {
      return null;
    }
    AgreementReportVo vo = new AgreementReportVo();
    vo.setCashTotal(BigDecimal.ZERO);
    vo.setOrderTotal(BigDecimal.ZERO);
    vo.setOrderAmountTotal(BigDecimal.ZERO);

    //查询协议信息
    AgreementVo agreementVo = agreementVoService.findByAgreementCode(code);
    if (agreementVo == null) {
      return null;
    }
    AgreementRewardDto rewardDto = new AgreementRewardDto();
    rewardDto.setCode(code);
    rewardDto.setType(type);
    Page<AgreementRewardVo> conditions = agreementRewardVoService.findByConditions(PageRequest.of(0, 50), rewardDto);
    if(conditions != null) {
      vo.setNumber((int) conditions.getTotal());
    }else {
      vo.setNumber(0);
    }
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(type)){
      this.buildVo(vo, agreementVo.getCustomerCode(), type);
    }
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(type)){
      this.buildVo(vo, agreementVo.getTerminalCode(), type);
    }
    if(ParticipatorTypeEnum.CONSUMER.getDictCode().equals(type)){
      List<ConsumerVo> consumers = consumerVoService.findByTerminalCode(agreementVo.getTerminalCode());
      BigDecimal cashTotal = BigDecimal.ZERO;
      BigDecimal costTotal = BigDecimal.ZERO;
      BigDecimal integralTotal = BigDecimal.ZERO;
      Integer number = 0;
      BigDecimal orderAmountTotal = BigDecimal.ZERO;
      BigDecimal redPacketTotal = BigDecimal.ZERO;
      BigDecimal orderTotal = BigDecimal.ZERO;
      BigDecimal scanTotal = BigDecimal.ZERO;

      for(ConsumerVo consumerVo : consumers){
        this.buildVo(vo, consumerVo.getConsumerCode(), type);
        cashTotal = cashTotal.add(vo.getCashTotal() == null ? BigDecimal.ZERO : vo.getCashTotal());
        costTotal = costTotal.add(vo.getCostTotal() == null ? BigDecimal.ZERO : vo.getCostTotal());
        integralTotal = integralTotal.add(vo.getIntegralTotal() == null ? BigDecimal.ZERO : vo.getIntegralTotal());
        number = number + (vo.getNumber() == null ? 0 : vo.getNumber());
        orderAmountTotal = orderAmountTotal.add(vo.getOrderAmountTotal() == null ? BigDecimal.ZERO : vo.getOrderAmountTotal());
        redPacketTotal = redPacketTotal.add(vo.getRedPacketTotal() == null ? BigDecimal.ZERO : vo.getRedPacketTotal());
        orderTotal = orderTotal.add(vo.getOrderTotal() == null ? BigDecimal.ZERO : vo.getOrderTotal());
        scanTotal = scanTotal.add(vo.getScanTotal() == null ? BigDecimal.ZERO : vo.getScanTotal());
      }
      vo.setNumber(number);
      vo.setOrderAmountTotal(orderAmountTotal);
      vo.setOrderTotal(orderTotal);
      vo.setCashTotal(cashTotal);
      vo.setCostTotal(costTotal);
      vo.setIntegralTotal(integralTotal);
      vo.setRedPacketTotal(redPacketTotal);
      vo.setScanTotal(scanTotal);
    }
    return vo;
  }

  /**
   * 根据编码查询
   * @param code
   * @return
   */
  @Override
  public AgreementReportVo findByAgreementCode(String code) {
    if(StringUtils.isBlank(code)){
      return null;
    }
    AgreementVo agreementCode = this.agreementVoService.findByAgreementCode(code);
    if (agreementCode == null) {
      return null;
    }
    AgreementReportVo vo = new AgreementReportVo();
    BigDecimal costTotal = BigDecimal.ZERO;
    BigDecimal integralTotal = BigDecimal.ZERO;
    BigDecimal redPacketTotal = BigDecimal.ZERO;
    BigDecimal scanTotal = BigDecimal.ZERO;
    //查询奖励信息
    ArrayList<String> strings = new ArrayList<>();
    strings.add(agreementCode.getTemplateCode());
    //todo 暂时没有协议维度的统计
    List<RewardRelAgreementVo> rewardRelAgreementVos = rewardRelAgreementVoService.findByParticipatorCodeAndTemplateCodes(null, strings);
    if(!CollectionUtils.isEmpty(rewardRelAgreementVos)){
      List<RewardTypeStatisticsVo> rewardTypeStatisticsVos = rewardRelAgreementVos.get(0).getRewardTypeStatisticsVos();
      for (RewardTypeStatisticsVo re : rewardTypeStatisticsVos) {
        BigDecimal amount =  re.getAmount() == null ? BigDecimal.ZERO : re.getAmount();
        if (RedPacketConstant.REDPACKAGE_KEY.equals(re.getKey())) {
          redPacketTotal = amount;
        }
        if (IntegralConstant.INTEGRAL_KEY.equals(re.getKey())) {
          integralTotal = amount;
        }
        if (CostConstant.COST_KEY.equals(re.getKey())) {
          costTotal = amount;
        }
      }
    }
    //查询扫码次数
    List<ScanCodeConfiguration> scanCodeConfigurations = this.scanCodeConfigurationService.findDetailsByTemplateCode(agreementCode.getTemplateCode());
    if (!CollectionUtils.isEmpty(scanCodeConfigurations)) {
      ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto = new ScanCodeRecordStatisticsDto();
      ArrayList<String> list = Lists.newArrayList();
      ScanCodeConfiguration scanCodeConfiguration = scanCodeConfigurations.get(0);
      if (!MaterialDimensionConstant.DIMENSION_ALL.equals(scanCodeConfiguration.getDimensionFlag())) {
        List<String> materialCodeList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(scanCodeConfiguration.getScanCodeRanges().stream().map(ScanCodeRange::getSpecialCode).collect(Collectors.toList()), scanCodeConfiguration.getDimensionFlag());
        list.addAll(materialCodeList);
      }
      scanCodeRecordStatisticsDto.setMaterialCodes(list);
      Integer integer = this.scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
      scanTotal = integer == null ? BigDecimal.ZERO : new BigDecimal(integer);
    }
    vo.setScanTotal(scanTotal);
    vo.setCostTotal(costTotal);
    vo.setIntegralTotal(integralTotal);
    vo.setRedPacketTotal(redPacketTotal);
    return vo;
  }

  /**
   * 构建结果
   * @param vo
   * @param code
   * @param type
   */
  private void buildVo(AgreementReportVo vo, String code, String type) {
    //红包
    RedPacketEntity redPacket = redPacketService.findByParticipatorCode(code);
    if(redPacket != null){
      vo.setRedPacketTotal(redPacket.getAccruingRedPacket() == null ? BigDecimal.ZERO : redPacket.getAccruingRedPacket());
    } else {
      vo.setRedPacketTotal(BigDecimal.ZERO);
    }
    //费用
    //经销商费用
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(type)){
      CostDealerEntity dealer = costDealerService.findByDealerCode(code);
      if(dealer != null){
        vo.setCostTotal(dealer.getTotalAmount() == null ? BigDecimal.ZERO : dealer.getTotalAmount());
      } else {
        vo.setCostTotal(BigDecimal.ZERO);
      }
    }
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(type)){
      CostTerminalEntity terminal = costTerminalService.findByTerminalCode(code);
      if(terminal != null){
        vo.setCostTotal(terminal.getTotalAmount() == null ? BigDecimal.ZERO : terminal.getTotalAmount());
      } else {
        vo.setCostTotal(BigDecimal.ZERO);
      }
    }

    //积分
    IntegralEntity integral = integralService.findByParticipatorCode(code);
    if(integral != null){
      vo.setIntegralTotal(integral.getAccruingIntegral() == null ? BigDecimal.ZERO : integral.getAccruingIntegral());
    } else {
      vo.setIntegralTotal(BigDecimal.ZERO);
    }

    //扫码
    ScanCodeRecordStatisticsDto dto = new ScanCodeRecordStatisticsDto();
    dto.setScanParticipatorCode(code);
    Integer integer = scanCodeRecordVoService.countByScanCodeRecordDto(dto);
    vo.setScanTotal(integer == null ? BigDecimal.ZERO : new BigDecimal(integer));
  }
}
