package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.AgreementRewardDto;
import com.biz.crm.admin.web.repository.AgreementRewardVoRepository;
import com.biz.crm.admin.web.service.AgreementRewardVoService;
import com.biz.crm.admin.web.vo.AgreementRewardVo;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 协议分利明细报表service实现
 * @Author: zengxingwang
 * @Date: 2021/9/18 14:03
 */
@Service
public class AgreementRewardVoServiceImpl implements AgreementRewardVoService {

  @Autowired
  private AgreementVoService agreementVoService;
  @Autowired
  private AgreementRewardVoRepository agreementRewardVoRepository;
  @Autowired
  private ConsumerVoService consumerVoService;

  /**
   * 多条件查询
   * @param pageable
   * @param agreementRewardDto
   * @return
   */
  @Override
  public Page<AgreementRewardVo> findByConditions(Pageable pageable, AgreementRewardDto agreementRewardDto) {
    if(agreementRewardDto == null || StringUtils.isBlank(agreementRewardDto.getType()) || StringUtils.isBlank(agreementRewardDto.getCode())){
      return new Page<>();
    }
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    //查询协议信息
    AgreementVo agreementVo = agreementVoService.findByAgreementCode(agreementRewardDto.getCode());
    if (agreementVo == null) {
      return new Page<>();
    }
    //经销商
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(agreementRewardDto.getType())){
      agreementRewardDto.setParticipatorCodes(Arrays.asList(agreementVo.getCustomerCode()));
      return agreementRewardVoRepository.findByConditions(pageable, agreementRewardDto);
    }
    //终端
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(agreementRewardDto.getType())){
      agreementRewardDto.setParticipatorCodes(Arrays.asList(agreementVo.getTerminalCode()));
      return agreementRewardVoRepository.findByConditions(pageable, agreementRewardDto);
    }
    //消费者
    if(ParticipatorTypeEnum.CONSUMER.getDictCode().equals(agreementRewardDto.getType())){
      List<ConsumerVo> consumers = consumerVoService.findByTerminalCode(agreementVo.getTerminalCode());
      List<String> codes = new ArrayList<>();
      consumers.stream().forEach(item -> codes.add(item.getConsumerCode()));
      agreementRewardDto.setParticipatorCodes(codes);
      return agreementRewardVoRepository.findByConditions(pageable, agreementRewardDto);
    }
    return new Page<>();
  }
}
