package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.CashRecordReportDto;
import com.biz.crm.admin.web.repository.CashRecordReportVoRepository;
import com.biz.crm.admin.web.service.CashRecordReportVoService;
import com.biz.crm.admin.web.vo.CashRecordReportVo;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 提现流水报表
 * @date 2021/10/11 下午4:51
 */
@Service
public class CashRecordReportVoServiceImpl implements CashRecordReportVoService {

  @Autowired
  private CashRecordReportVoRepository cashRecordReportVoRepository;
  @Autowired
  private TaxRaiseWithdrawalAccountVoService taxRaiseWithdrawalAccountVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private UserFeignVoService userFeignVoService;

  @Override
  public Page<CashRecordReportVo> findTerminalByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    Page<CashRecordReportVo> page = cashRecordReportVoRepository.findTerminalByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(page.getRecords())){
      return page;
    }
    Page<CashRecordReportVo> pageResult = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    List<CashRecordReportVo> list = (List<CashRecordReportVo>) this.nebulaToolkitService.copyCollectionByBlankList(page.getRecords()
        , CashRecordReportVo.class, CashRecordReportVo.class, HashSet.class, ArrayList.class);
    List<String> payeeCodes = list
        .stream().map(CashRecordReportVo::getPayeeCode).distinct().collect(Collectors.toList());
    //赋值实名认证相关信息
    this.handelWithdrawalAccount(list,payeeCodes);
    pageResult.setRecords(list);
    return pageResult;
  }

  @Override
  public Page<CashRecordReportVo> findDealerByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    Page<CashRecordReportVo> page = cashRecordReportVoRepository.findDealerByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(page.getRecords())){
      return page;
    }
    Page<CashRecordReportVo> pageResult = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    List<CashRecordReportVo> list = (List<CashRecordReportVo>) this.nebulaToolkitService.copyCollectionByBlankList(page.getRecords()
        , CashRecordReportVo.class, CashRecordReportVo.class, HashSet.class, ArrayList.class);
    List<String> payeeCodes = list
        .stream().map(CashRecordReportVo::getPayeeCode).distinct().collect(Collectors.toList());
    //赋值实名认证相关信息
    this.handelWithdrawalAccount(list,payeeCodes);
    pageResult.setRecords(list);
    return pageResult;
  }

  @Override
  public Page<CashRecordReportVo> findConsumerByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    return cashRecordReportVoRepository.findConsumerByConditions(pageable, dto);
  }

  @Override
  public Page<CashRecordReportVo> findUserGuideByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    Page<CashRecordReportVo> page = cashRecordReportVoRepository.findUserGuideByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(page.getRecords())){
      return page;
    }
    Page<CashRecordReportVo> pageResult = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    List<CashRecordReportVo> list = (List<CashRecordReportVo>) this.nebulaToolkitService.copyCollectionByBlankList(page.getRecords()
        , CashRecordReportVo.class, CashRecordReportVo.class, HashSet.class, ArrayList.class);
    List<String> participatorCodes = list
        .stream().map(CashRecordReportVo::getParticipatorCode).distinct().collect(Collectors.toList());
    //查询导购用户信息
    List<UserVo> userVos = userFeignVoService.findByUserNames(participatorCodes);
    if (!CollectionUtils.isEmpty(userVos)){
      List<String> accountCodes = userVos.stream().map(UserVo::getUserCode).collect(Collectors.toList());
      //赋值实名认证相关信息
      this.handelWithdrawalAccount(list,accountCodes);
    }
    pageResult.setRecords(list);
    return pageResult;
  }

  /**
   * 赋值实名认证相关信息
   * @param list
   * @param merchantUserAccounts 税筹平台的商户平台用户账户
   */
  private void handelWithdrawalAccount (List<CashRecordReportVo> list,List<String> merchantUserAccounts){
    //查询税筹账户信息
    MerchantAccountBatchDto merchantAccountBatchDto = new MerchantAccountBatchDto();
    merchantAccountBatchDto.setMerchantUserAccounts(merchantUserAccounts);
    List<TaxRaiseWithdrawalAccountVo> withdrawalAccountVos = taxRaiseWithdrawalAccountVoService.findByMerchantAccountBatchDto(merchantAccountBatchDto);
    if (CollectionUtils.isEmpty(withdrawalAccountVos)){
      return;
    }
    Map<String, TaxRaiseWithdrawalAccountVo> map = withdrawalAccountVos
        .stream().collect(Collectors.toMap(TaxRaiseWithdrawalAccountVo::getMerchantUserAccount, Function.identity()));
    for (CashRecordReportVo cashRecordReportVo : list) {
      if (map.containsKey(cashRecordReportVo.getPayeeCode())){
        TaxRaiseWithdrawalAccountVo accountVo = map.get(cashRecordReportVo.getPayeeCode());
        cashRecordReportVo.setPersonName(accountVo.getPersonName());
        cashRecordReportVo.setIdCard(accountVo.getIdCard());
        cashRecordReportVo.setMobile(accountVo.getMobile());
        cashRecordReportVo.setBankCardNo(accountVo.getBankCardNo());
        cashRecordReportVo.setHeadPhotoPathUrl(accountVo.getHeadPhotoPathUrl());
        cashRecordReportVo.setBackgroundIdCardPathUrl(accountVo.getBackgroundIdCardPathUrl());
      }
    }
  }
}
