package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerReportDto;
import com.biz.crm.admin.web.dto.ConsumerTerminalMappingDto;
import com.biz.crm.admin.web.repository.ConsumerReportRepository;
import com.biz.crm.admin.web.service.ConsumerReportService;
import com.biz.crm.admin.web.service.ConsumerTerminalMappingReportService;
import com.biz.crm.admin.web.vo.ConsumerReportVo;
import com.biz.crm.admin.web.vo.ConsumerTerminalMappingReportVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.KeyValueVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 消费者报表service实现
 * @author songjingen
 */
@Service
public class ConsumerReportServiceImpl implements ConsumerReportService {

  @Autowired
  private ConsumerReportRepository consumerReportRepository;

  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;

  @Autowired
  private ConsumerTerminalMappingReportService consumerTerminalMappingReportService;

  /**
   * 消费者报表分页查询
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<ConsumerReportVo> findByConditions(Pageable pageable, ConsumerReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if(dto == null) {
      dto = new ConsumerReportDto();
    }
    Page<ConsumerReportVo> page = consumerReportRepository.findByConditions(pageable, dto);
    if (Objects.isNull(page)) {
      return null;
    }
    List<String> scanCodeRecords = page.getRecords().stream().map(ConsumerReportVo :: getExternalId).collect(Collectors.toList());
    List<KeyValueVo> vos = scanCodeRecordVoService.countByScanCodeRecordGroup(scanCodeRecords);
    Map<String, Long> map = new HashMap<>();
    if(!CollectionUtils.isEmpty(vos)){
      for(KeyValueVo vo : vos){
        map.put(vo.getKey(), vo.getValue());
      }
    }
    if(map != null) {
      page.getRecords().stream().forEach(item -> {
        Long count = map.get(item.getExternalId());
        if(count != null){
          item.setScanCount(count.intValue());
        }else {
          item.setScanCount(0);
        }
      });
    }
    List<ConsumerReportVo> list = page.getRecords();
    if (!CollectionUtils.isEmpty(list)) {
      //关联终端数量
      List<String> ids = list.stream().map(ConsumerReportVo::getId).collect(Collectors.toList());
      ConsumerTerminalMappingDto consumerTerminalMappingDto = new ConsumerTerminalMappingDto();
      consumerTerminalMappingDto.setConsumerIds(ids);
      List<ConsumerTerminalMappingReportVo> byConditions = this.consumerTerminalMappingReportService.findByConditions(consumerTerminalMappingDto);
      if (!CollectionUtils.isEmpty(byConditions)) {
        list.stream().forEach(consumerReportVo -> {
          long count = byConditions.stream().filter(consumerTerminalMappingReportVo -> consumerReportVo.getId().equals(consumerTerminalMappingReportVo.getConsumerId())).count();
          consumerReportVo.setInvolveTerminalCount(Long.valueOf(count).intValue());
        });
      }

    }
    return page;
  }

  /**
   * 消费者分利信息
   * @param consumerCode 消费者编码
   * @return
   */
  @Override
  public ConsumerReportVo findDetailsByConsumerCode(String consumerCode) {
    if (StringUtils.isBlank(consumerCode)) {
      return null;
    }
    ConsumerReportVo consumerReportVo = this.consumerReportRepository.findDetailsByConsumerCode(consumerCode);
    if (Objects.isNull(consumerReportVo)) {
      return null;
    }
    ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto = new ScanCodeRecordStatisticsDto();
    scanCodeRecordStatisticsDto.setScanParticipatorCode(consumerReportVo.getExternalId());
    Integer integer = scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
    consumerReportVo.setScanCount(integer);
    return consumerReportVo;
  }
}
